/*
 * cbcps - Call Back Configuration Protocol. SERVER
 * Miro Bobovsky , 7.11.1998 ver2.0
 * robte s tym co chete - GPL a lubovolny iny vse povoliaci.
 * ocakavam za pppd prepinac auth +chap -pap cb ip:ip 
 * ocakavam subor /etc/ppp/callbusers kde su user (nestaci chap-s) 
 * s patricnym sytaxom meno!P!V!A!cislo!.
 * snazim sa spustit /etc/ppp/callbackser pre volanie. (pppd chat).
*/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <syslog.h>

#include "pppd.h"
#include "fsm.h"
#include "lcp.h"
#include "ipcp.h"
#include "cbcps.h"
 
extern void network_phase __P((int));

void cbcp_recvresp(cbcp_state *us, char *pckt, int len);
void cbcp_sendack(cbcp_state *us,u_char type,u_char delay );

cbcp_state cbcp[NUM_PPP];
char cbcpuser[20];
int cbcp_priamo=1,cbcp_volit=0,cbcp_admin=0;
char cbcp_adminn[]="********************";
struct protent cbcp_protent = {
    PPP_CBCP,
    cbcp_init,
    cbcp_input,
    cbcp_protrej,
    cbcp_lowerup,
    NULL,
    cbcp_open,
    NULL,
    cbcp_printpkt,
    NULL,
    0,
    "CBCP",
    NULL,
    NULL,
    NULL
};


void cbcp_lowerup(int iface)	//vola lcp.c
{
LCPDEBUG((LOG_DEBUG," bbo cbcp_lowerup"));
}

void cbcp_init(int iface)	// z main.c
{
    cbcp_state *us;

    LCPDEBUG((LOG_DEBUG," bbo cbcp_init"));
    cbcpuser[0]=0;
    cbcp_volit=cbcp_admin=0;
    cbcp_priamo=1;
    cbcp_adminn[0]=0;
    us = &cbcp[iface];
    memset(us, 0, sizeof(cbcp_state));
    us->us_unit = iface;
}

void cbcp_open(int unit)  //z auth -- startuje cbcp komunikaciu
{
    u_char buf[256];
    u_char *bufp = buf;
    u_char *outp;
    int outlen;
    cbcp_state *us = &cbcp[unit];

    us->us_id = 1;
    outp = outpacket_buf;
    outlen=4;                //hlavicka
    if(cbcp_priamo) { outlen+=2;
      PUTCHAR(CB_CONF_NO, bufp);PUTCHAR(2 , bufp);}
    if(cbcp_volit) { outlen+=5;
      PUTCHAR(CB_CONF_USER, bufp);PUTCHAR(5 , bufp); //typ,dlzka
      PUTCHAR(0, bufp);PUTCHAR(1, bufp);PUTCHAR(0, bufp);} //delay,atyp,cisloZ
    if(cbcp_admin) { outlen+=2;
      PUTCHAR(CB_CONF_ADMIN, bufp);PUTCHAR(2 , bufp);}
    LCPDEBUG((LOG_DEBUG, "bbo cbcp_open"));
    MAKEHEADER(outp, PPP_CBCP);  // a dorobim paket , dlzky a ...
    PUTCHAR(CBCP_REQ, outp);  // prikaz
    PUTCHAR(us->us_id,outp); //id
    PUTSHORT(outlen, outp);       // IBAZE WINNT posiela to kazde 2 sek.
    BCOPY(buf, outp, outlen-4);   // s novym id a ja len raz .. ale ide.
    output(1, outpacket_buf, outlen + PPP_HDRLEN);
}

void cbcp_close(int unit)
{
    LCPDEBUG((LOG_DEBUG, "bbo cbcp_close"));
}

/* process an incomming packet */
void cbcp_input(int unit, u_char *inpacket, int pktlen)
{
    u_char *inp;
    u_char code, id;
    u_short len;

    cbcp_state *us = &cbcp[unit];
    inp = inpacket;
    LCPDEBUG((LOG_DEBUG," bbo cbcp_input"));
    if (pktlen < CBCP_MINLEN) {
        syslog(LOG_ERR, "CBCP packet is too small");
        return;
    }

    GETCHAR(code, inp);
    GETCHAR(id, inp);
    GETSHORT(len, inp);

    if (len > pktlen) {
        syslog(LOG_ERR, "CBCP packet: invalid length");
        return;
    }

    len -= CBCP_MINLEN;

    switch(code) {
    case CBCP_REQ:	// toto je neosetrene bo nema co prist.
        syslog(LOG_ERR, "CBCP_REQ received !!!!");
        break;

    case CBCP_RESP:
        LCPDEBUG((LOG_DEBUG, "CBCP_RESP received"));
        if (id != us->us_id)
          syslog(LOG_ERR,"CBCP RESP zle id, caka %d dostal %d",us->us_id,id);
        cbcp_recvresp(us,inp,len);
        break;

    case CBCP_ACK:    // toto je neosetrene bo nema co prist.
        syslog(LOG_ERR, "CBCP_ACK received !!!!");
        break;

    default:
        break;
    }
}

/* protocol was rejected by foe */
void cbcp_protrej(int iface)
{
   LCPDEBUG((LOG_DEBUG," bbo cbcp_protrej"));
}
int cbcp_printpkt(u_char *p, int plen,
                   void (*printer) __P((void *, char *, ...)),
                   void *arg)
{
 LCPDEBUG((LOG_DEBUG," bbo cbcp_printpkt"));
 return 0; //urcite zle lebo mal vratit kolko asi pochopil znakov.
}

void cbcp_recvresp(cbcp_state *us, char *pckt, int len)
{
    u_char type, delay=0, addr_type;
    int opt_len,dlzka;

    if (len<2) {  
        syslog(LOG_ERR, "CBCP recvresp: kratky, %d",len);
        phase=PHASE_TERMINATE; return;}

      GETCHAR(type, pckt);
      GETCHAR(opt_len, pckt);

      if (opt_len > 2)
          GETCHAR(delay, pckt);
      switch(type) {
       case CB_CONF_NO:
         if(cbcp_admin)
          {syslog(LOG_ERR,"CBCP got CB_CONF_NO while cbcp_admin is set");
           phase=PHASE_TERMINATE; type=CB_CONF_NOT_ALLOWED; break;}
/*         if(!cbcp_priamo)
          {syslog(LOG_ERR, "CBCP Podvadza - vratil co som nenukal");
           phase=PHASE_TERMINATE; return;}
*/
         break;
       case CB_CONF_ADMIN:
         if(!cbcp_admin)
          {syslog(LOG_ERR, "CBCP Podvadza - vratil co som nenukal");
           phase=PHASE_TERMINATE; return;}
         break;
       default:   // t.j. asi voli ale pozreme.
	 if(!cbcp_volit)
          {syslog(LOG_ERR, "CBCP Podvadza - vratil co som nenukal");
           phase=PHASE_TERMINATE; return;}
	 if(opt_len>4) {
	   GETCHAR(addr_type, pckt);
           dlzka=opt_len - 4<20?opt_len - 4:19;
           memcpy(cbcp_adminn, pckt, dlzka);
           cbcp_adminn[dlzka]=0;
           LCPDEBUG((LOG_DEBUG, "mam cislo: %s", cbcp_adminn));
	 }
      }
      cbcp_sendack(us,type,delay);      
}

void cbcp_sendack( cbcp_state *us,u_char type,u_char delay )
{
    u_char buf[256];
    u_char *bufp = buf;
    int len = 0;
    u_char *outp;
    int outlen;

    outp = outpacket_buf;
    switch(type) {
     case CB_CONF_NO:
	len=2;PUTCHAR(CB_CONF_NO, bufp);PUTCHAR(len , bufp);
        break;
     case CB_CONF_USER:
        len=strlen(cbcp_adminn)+5;
	PUTCHAR(CB_CONF_USER, bufp);PUTCHAR(len, bufp);PUTCHAR(delay, bufp);
	PUTCHAR(1, bufp);BCOPY(cbcp_adminn,bufp,len-5);bufp+=len-5;
	PUTCHAR(0, bufp);break;
     case CB_CONF_ADMIN:
	len=3;PUTCHAR(CB_CONF_ADMIN,bufp);PUTCHAR(len,bufp);PUTCHAR(delay,bufp);
	break;
     default:
	syslog(LOG_ERR, "CBCP Podvadza - v type");
        phase=PHASE_TERMINATE; break;
    }
    LCPDEBUG((LOG_DEBUG, "bbo cbcp_sendack"));
    outlen = 4 + len;
    MAKEHEADER(outp, PPP_CBCP);
    PUTCHAR(CBCP_ACK, outp);
    PUTCHAR(us->us_id,outp);
    PUTSHORT(outlen, outp);
    BCOPY(buf, outp, len);
    output(1, outpacket_buf, outlen + PPP_HDRLEN);
    if(phase != PHASE_TERMINATE) network_phase(us->us_unit);

if(type==CB_CONF_ADMIN || type==CB_CONF_USER){ //spustenie programu na volanie
char *argv[4];
    argv[0] = "/etc/ppp/callbackser";    //progam
    argv[1] = devnam;		// /dev/ttyS?
    argv[2] = cbcpuser;    //ID
    argv[3] = cbcp_adminn;        // cislo
    argv[4] = user;
    argv[5] = NULL;
    run_program(argv[0], argv, 0);
 }
}

int akysposobppp(char *kto)
{
 FILE *fp;
 char *a,*b;
 char riadok[81];

 cbcp_volit=cbcp_admin=0;
 cbcp_priamo=1;
 cbcp_adminn[0]=0;
 if(strlen(kto)<2) {syslog(LOG_ERR,"CBCP - kratke meno"); return 0;}
 if((fp=fopen("/etc/ppp/callbusers","r"))==NULL)
   {syslog(LOG_ERR,"CBCP neviem otvorit callbusers");return 0;}
 while(fgets(riadok,80,fp)!=NULL){
   if( *riadok=='#' ) continue;
   if( (a=strchr(riadok,'!'))!=NULL ) *(a++)=0;
   if(strcmp(riadok,kto)==0) {
    if( strlen(a)<5 ) {syslog(LOG_ERR,"CBCP chybny riadok");
		       fclose(fp);return 0;}
    if( *(a++)=='P') {a++;cbcp_priamo=1;}
    if( *(a++)=='V') {a++;cbcp_volit=1;cbcp_priamo=0;}
    if( *(a++)=='A') {
	a++;
	if( (b=strchr(a,'!'))!=NULL ) 
	  {*b=0;strncpy(cbcp_adminn,a,20);cbcp_admin=1;}
	}
    fclose(fp); 
    syslog(LOG_INFO,"meno:%s P:%d V:%d A:%d cislo:[%s]\n",
	kto,cbcp_priamo,cbcp_volit,cbcp_admin,cbcp_adminn);
     return 1;}
 }
 fclose(fp);syslog(LOG_ERR,"CBCP neni v callbusers");return 0;
}

