/*   Copyright (c) 1997      Cyril A. Vechera      St.-Petersburg, RUSSIA
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *  4. Any form of use of source and binaries are permitted only for
 *     noncommercial purpose. Any forms of commercial usage require
 *     direct author's permission.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <syslog.h>
#include <utmp.h>

#include "fsm.h"
#include "ipcp.h"
#include "lcp.h"
#include "pppd.h"
#include "upap.h"
#include "libradius.h"
#include "pppdradius.h"

char 	rad_user[16] = "\0";
u_long	rad_port = 0;
u_long	rad_address = 0L;
u_long	rad_netmask = 0L;
u_long	rad_mtu = 0L;
u_long	rad_vj = 0L;
int	radlogged_in = 0;

extern int cbcp_volit;

int radlogin (char *name, char *passwd)
{
    int err,i;
    u_long *radppp_address;
    u_long *radppp_netmask;
    u_long *radppp_mtu;
    u_long *radppp_vj;
    struct stat s;
    struct utmp utmp;    
    char *tty;           

    strncpy (rad_user, name, 16);
    radppp_address = &rad_address;
    radppp_netmask = &rad_netmask;
    radppp_mtu = &rad_mtu;
    radppp_vj = &rad_vj;

    if (fstat (ttyfd, &s))
	s.st_rdev = 0;
    rad_port = (major(s.st_rdev) << 12) | (minor(s.st_rdev) & 0x0fff);

    err = radius_request_ppp_PAP (rad_user, passwd, rad_port, &radppp_address,
    		&radppp_netmask, &radppp_mtu, &radppp_vj);

    syslog(LOG_WARNING,"RADIUS auth passed: err %d",err);
    if (!err) /* if authenticated successfully - start accounting */
    {
	radius_session_start_time = time(NULL);

/* session id - nas-ip-address + tty-device + pid + time */
	sprintf(radius_session_id, "%s %s [%u] %s",
		 inet_ntoa (radius_me.sin_addr),
		 devname (s.st_rdev, S_IFCHR),
		 getpid(),
		 ctime(&radius_session_start_time));

	radius_account_start (rad_user, rad_port);
        syslog(LOG_WARNING,"RADIUS accounting started: err %d",err);
    }

    switch (err)
    {
	case RADLIB_ACCESS_DENIED:
		syslog(LOG_WARNING, "radlogin: access denied for user %s\n", name);
		break;
	case RADLIB_NO_RESPONSE:
		syslog(LOG_ALERT, "radlogin: server doesn't respond\n");
		break;
	case RADLIB_BAD_ID:
		syslog(LOG_ERR, "radlogin: bad response identifier\n");
		break;
	case RADLIB_BAD_AUTH:
		syslog(LOG_ERR, "radlogin: server's response authentication failure\n");
		break;
	case RADLIB_BAD_CODE:
		syslog(LOG_ERR, "radlogin: bad response code\n");
		break;
    }

    if (err)
	return UPAP_AUTHNAK;

    radlogged_in = 1;

    if (radppp_netmask)
    {
	memcpy (&netmask, radppp_netmask, 4);
	syslog (LOG_DEBUG, "RADIUS netmask: %lx\n",netmask);
    }

    if (radppp_address)
    {
	memcpy (&ipcp_allowoptions[0].hisaddr, radppp_address, 4);
	memcpy (&ipcp_wantoptions[0].hisaddr, radppp_address, 4);
	syslog (LOG_DEBUG, "RADIUS address: %lx\n", ipcp_wantoptions[0].hisaddr);
    }
    tty = devnam;                     
    if (strncmp(tty, "/dev/", 5) == 0)
        tty += 5;                     
    for(i=0;i<sizeof(utmp.ut_name);i++) if(user[i]=='@') {user[i]=0;break;}
    memset((void *)&utmp, 0, sizeof(utmp));                   
    (void)time(&utmp.ut_time);                                
    (void)strncpy(utmp.ut_name,name, sizeof(utmp.ut_name));  
    if(cbcp_volit==1) (void)strncpy(utmp.ut_host, "CALLBACK", sizeof(utmp.ut_host));
    else (void)strncpy(utmp.ut_host, "DIAL-IN", sizeof(utmp.ut_host));
    (void)strncpy(utmp.ut_line, tty, sizeof(utmp.ut_line));   
    login(&utmp);                                             
    return UPAP_AUTHACK;
}

void radlogout (void)
{
    int err;

    err=radius_account_stop(rad_user, rad_port, time(NULL)-radius_session_start_time);
    switch (err)
    {
	case RADLIB_NO_RESPONSE:
		syslog(LOG_ALERT, "radlogout: server doesn't respond\n");
		break;
	case RADLIB_BAD_ID:
		syslog(LOG_ERR, "radlogout: bad response identifier\n");
		break;
	case RADLIB_BAD_AUTH:
		syslog(LOG_ERR, "radlogout: server's response authentication failure\n");
		break;
	case RADLIB_BAD_CODE:
		syslog(LOG_ERR, "radlogout: bad response code\n");
		break;
    }
    radlogged_in = 0;
    return;
}
