#include <stdio.h>

#include "pppd.h"
#include "chap.h"
#include "chap_ms.h"

int main(argc, argv)
    int     argc;
    char    *argv[];
{
    u_char          challenge[8];
    int             challengeInt[sizeof(challenge)];
    chap_state      cstate;
    int             i;

    if (argc != 3) {
        fprintf(stderr, "Usage: %s <16-hexchar challenge> <password>\n",
        argv[0]); exit(1);
    }

    sscanf(argv[1], "%2x%2x%2x%2x%2x%2x%2x%2x",
           challengeInt + 0, challengeInt + 1, challengeInt + 2,
           challengeInt + 3, challengeInt + 4, challengeInt + 5,
           challengeInt + 6, challengeInt + 7);

    for (i = 0; i < sizeof(challenge); i++)
        challenge[i] = (u_char)challengeInt[i];

    ChapMS(&cstate, challenge, sizeof(challenge), argv[2], strlen(argv[2]));
    printf("Response length is %d, response is:", cstate.resp_length);

    for (i = 0; i < cstate.resp_length; i++) {
        if (i % 8 == 0)
            putchar('\n');
        printf("%02X ", (unsigned int)cstate.response[i]);
    }

    putchar('\n');

    exit(0);
}
