#ifndef LIBRADIUS_H
#define LIBRADIUS_H

#include <netinet/in.h>
#include <sys/time.h>

/* sizes */
#define RADLIB_MAX_PACKET_SIZE	1024
#define RADLIB_DEFAULT_RETRY_MAX	3
#define RADLIB_DEFAULT_TIMEOUT		1
#define RADLIB_DEFAULT_RADIUS_PORT	1645
#define RADLIB_DEFAULT_RADACC_PORT	1646

/* error codes */
#define RADLIB_ACCESS_DENIED	1
#define RADLIB_NO_RESPONSE	2
#define RADLIB_BAD_ID		3
#define RADLIB_BAD_AUTH		4
#define RADLIB_BAD_CODE		5




#define u_char unsigned char
#define u_long unsigned long
#define u_short unsigned short


typedef struct
{
	u_char code;
	u_char id;
	u_short length;
	u_long auth[4];
} TRadiusHeader;

int radius_init(char *);
int radius_send_query (u_char *, u_char *, struct sockaddr_in *);
int radius_response_auth (char *, char *);
int radius_request_ppp_PAP (char *, char *, u_long, u_long **, u_long **, u_long **, u_long **);
int radius_account_start (u_char *, u_long);
int radius_account_stop (u_char *, u_long, time_t);
void radius_encrypt_password (char *, char *, char *);
void radius_create_auth (char *);

int md5_calc (u_char *, u_char *, int);



extern int			radius_retry_max;
extern char			radius_secret[];
extern struct sockaddr_in	radius_me;
extern struct sockaddr_in	radius_server;
extern struct sockaddr_in	radius_servac;
extern struct timeval		radius_timeout;
extern int			radius_id;
extern time_t			radius_session_start_time;
extern char			radius_session_id[];
extern int			radius_accounting;
extern int			radius_debug;

#endif